/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************

   In this tutorial is presented how to use lighting created in World Editor
   Here 2 light sources are used:
      1st is a static light defined in a constant position in the World Editor
      2nd is a light stored in a candle object, as a sub-object

/******************************************************************************/
struct Item : Game::Item // extend game items
{
   Game::LightPoint light_point; // point light

   virtual void create(Game::ObjParams &obj); // extend creation
   virtual void draw  (       );              // extend drawing
   virtual void save  (File &f);              // extend saving
   virtual Bool load  (File &f);              // extend loading
};
/******************************************************************************/
void Item::create(Game::ObjParams &obj)
{
   __super::create(obj); // default create

   // add custom children
   for(Game::ObjParams *cur=&obj; cur; cur=cur->base()) // check 'obj' and all its bases
      FREPA(cur->sub_obj) // for each sub-object in 'cur'
      {
         Game::ObjParams &o=cur->sub_obj[i];

         switch(Game::World.objType(o.type())) // check the type of sub-object
         {
            case OBJ_LGT_PNT: // if its light, then create our member from its parameters
               light_point.create(o);
            break; 
         }
      }
}
/******************************************************************************/
void Item::draw()
{
   if(0) // optionally you can disable shadow casting of the item, when the item is the light source
   {
      if(Renderer()==RM_SHD_MAP && Lgt.src==&light_point)return; // if in shadowing mode and current light source is 'light_point' then don't draw anything
   }

   __super ::  draw(              ); // default draw
   light_point.draw(actor.matrix()); // draw light with item's matrix
}
/******************************************************************************/
void Item::save(File &f)
{
   __super::save(f); // save default data

   light_point.save(f); // save point light
}
Bool Item::load(File &f)
{
   if(__super::load(f)) // load default data
   {
      light_point.load(f); // load point light
      return true;
   }
   return false;
}
/******************************************************************************/
Game::ObjMemx<Item            > Items;
Game::ObjMemx<Game::LightPoint> LightPoints; // container for point light objects
/******************************************************************************/
void InitPre()
{
   App.name="Lights";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024);

   Cam.dist =10;
   Cam.yaw  =-PI_4;
   Cam.pitch=-0.5;
   Cam.at.set(16,0,16);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();

   Game::World.init   (                       )
              .setType(Items      ,OBJ_ITEM   )
              .setType(LightPoints,OBJ_LGT_PNT)
              .New    ("world/lights"         )
              .update (Cam.at                 );

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Game::World.update(Cam.at);

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
